#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_xchg_IO16AX_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=AX;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
AX=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16BP_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=BP;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
BP=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16BX_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=BX;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
BX=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16CX_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=CX;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
CX=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16DI_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=DI;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
DI=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16DX_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=DX;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
DX=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16SI_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=SI;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
SI=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16SP_IO16AX(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;



arg0=SP;
arg1=AX;

save=arg0;
arg0=arg1;
arg1=save;
SP=arg0;
AX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsD16_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsD32_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsD32_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsrm161_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsrm321_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16dsrm322D32_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16r1rm161D16_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16r1rm161D8_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16r2rm162D16_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16r2rm162D8_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16r2rm162_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg0_off;
Bit16u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm321D32_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm321D32_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm321D8_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm321D8_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm321_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm323D32_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm323D8_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16rarm323_IO16regr2(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit32u arg0_off;
Bit16u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_16BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_word(arg0);
BX_READ_16BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO16regm_IO16regr(int seg,Bit8u* imm)
{
Bit16u save;
Bit16u arg0;
Bit16u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_16BIT_REG((last&0x7));
arg1=BX_READ_16BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
BX_READ_16BIT_REG((last&0x7))=arg0;
BX_READ_16BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32EAX_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=EAX;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
EAX=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32EBP_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=EBP;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
EBP=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32EBX_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=EBX;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
EBX=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32ECX_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=ECX;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
ECX=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32EDI_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=EDI;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
EDI=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32EDX_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=EDX;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
EDX=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32ESI_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=ESI;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
ESI=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32ESP_IO32EAX(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;



arg0=ESP;
arg1=EAX;

save=arg0;
arg0=arg1;
arg1=save;
ESP=arg0;
EAX=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsD16_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsD32_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsD32_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsrm161_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsrm321_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32dsrm322D32_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32r1rm161D16_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32r1rm161D8_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32r2rm162D16_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32r2rm162D8_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32r2rm162_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit16u arg0_off;
Bit32u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm321D32_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm321D32_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm321D8_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm321D8_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm321_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm323D32_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm323D8_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32rarm323_IO32regr2(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg0_off;
Bit32u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_READ_32BIT_REG((last2&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_dword(arg0);
BX_READ_32BIT_REG((last2&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO32regm_IO32regr(int seg,Bit8u* imm)
{
Bit32u save;
Bit32u arg0;
Bit32u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_READ_32BIT_REG((last&0x7));
arg1=BX_READ_32BIT_REG((last&0x38)/8);

save=arg0;
arg0=arg1;
arg1=save;
BX_READ_32BIT_REG((last&0x7))=arg0;
BX_READ_32BIT_REG((last&0x38)/8)=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD16_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD16_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD32_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD32_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD32_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsD32_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last2;
Bit32u disp;

last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off=disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm161_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm161_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm321_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm321_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm322D32_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8dsrm322D32_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r1rm161D16_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r1rm161D16_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r1rm161D8_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r1rm161D8_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162D16_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162D16_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162D8_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162D8_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8r2rm162_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit16u arg0_off;
Bit8u arg1;
Bit8u last;

last=*(imm-1);

arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

read_RMW_virtual_byte((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D32_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D32_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D32_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D32_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D8_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D8_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D8_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321D8_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm321_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7);

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323D32_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323D32_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit32u disp;

last=*(imm-1);
last2=*(imm-2);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323D8_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323D8_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;
Bit8s disp;

last=*(imm-1);
last2=*(imm-2);
disp=*imm;

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323_IO8reghr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8rarm323_IO8reglr2(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit32u arg0_off;
Bit8u arg1;
Bit8u last;
Bit8u last2;

last=*(imm-1);
last2=*(imm-2);

arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

read_RMW_virtual_byte((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);
arg1=BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
write_RMW_virtual_byte(arg0);
BX_CPU_THIS_PTR gen_reg[(last2&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8reghm_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8reghm_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rh=arg0;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8reglm_IO8reghr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh;

save=arg0;
arg0=arg1;
arg1=save;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rh=arg1;

}

void BX_CPU_C::EXEC_xchg_IO8reglm_IO8reglr(int seg,Bit8u* imm)
{
Bit8u save;
Bit8u arg0;
Bit8u arg1;
Bit8u last;

last=*(imm-1);


arg0=BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl;
arg1=BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl;

save=arg0;
arg0=arg1;
arg1=save;
BX_CPU_THIS_PTR gen_reg[(last&0x3)].word.byte.rl=arg0;
BX_CPU_THIS_PTR gen_reg[(last&0x18)/8].word.byte.rl=arg1;

}
